<?php

add_action( 'plugins_loaded', 'init_user_ui' , 10 );				

function init_user_ui(){

	global $pagenow;
	if ( is_admin() && ($pagenow=='user-edit.php' || $pagenow=='profile.php') ){
		
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-dialog' );	
		
		add_action('admin_head','user_tabs_css');
		add_action('admin_head','user_tabs_js');
		
		add_action( 'edit_user_profile', 'user_tabs_html',1,1);
		add_action( 'show_user_profile', 'user_tabs_html',1,1);
	}
}

function user_tabs_html($user)
{	
	global $wp_roles;
?>	
	<div id="todo_user_ui">

	<?php if ( get_option('show_avatars') ):?>
	<div style="float:right;width:96px;height:96px;margin:2px;vertical-align:absmiddle;border:1px solid #ccc;"><?php echo get_avatar( $user->ID, 96); ?></div>
	<?php endif;?>
	
	<br/><h1><?php echo $user->display_name?></h1>	
	<?php
	
	echo '<p>Este usuario tiene un perfil de: <strong>';
	foreach ( $wp_roles->role_names as $role => $name ) :
		if ( user_can( $user, $role ) )
			echo ' ' . $role ; 
	endforeach;
	echo "</strong></p>";?>
		
	<h2 class="nav-tab-wrapper" id="tabs">
		<a href="#" name="#tab1" class="nav-tab">Nombre</a>
		<a href="#" name="#tab2" class="nav-tab">Contacto</a>
		<a href="#" name="#tab3" class="nav-tab">Acerca de</a>
		<a href="#" name="#tab4" class="nav-tab">Categorías</a>	
		<a href="#" name="#tab5" class="nav-tab">Newsletter</a>
		
	</h2>

	<div id="content">
		<div id="tab1"></div>
		<div id="tab2"></div>
		<div id="tab3"></div>
		<div id="tab4"></div>
		<div id="tab5"></div>		
	</div>
	</div>	
<?php
}

function user_tabs_css()
{
?>
	<style type="text/css">		
		#wpbody {visibility:hidden;}
	</style>	
<?php
}

function user_tabs_js()
{
?>
<script type="text/javascript">
    
	function resetTabs(anchor)
	{       
 	    jQuery("#content > div").hide(); //Hide all content
        jQuery("#tabs a").removeClass("nav-tab-active"); //Reset id's   
		jQuery(".user-relations-filters a, .pagination-links a, .sortable a, .sorted a, a.relation_action").each(function() {      
			  var theHref = jQuery(this).attr("href");
			  jQuery(this).attr("href", theHref + anchor);
		});		   		
		location.href = location.href.split("#")[0] + anchor;
    }
   
	jQuery(document).ready(function($) { 
	
		//Reorder tabs
		
		var taxonomias = $(".user-category").remove();// Clasificacion
		var metaboxes = $(".rwmb-meta-box").remove();// Clasificacion
		//$("#wpbody .form-table").remove().appendTo("#your-profile");
		//$("#todo_user_ui").remove().appendTo("#your-profile");
		taxonomias.appendTo("#tab4"); 		
		metaboxes.appendTo("#tab5"); 	
		
		$("#your-profile > .form-table:eq(0)").remove().appendTo("#tab_inexistente"); // Options
		$("#your-profile > .form-table:eq(0)").remove().appendTo("#tab1"); 	// Nombre, clave, etc...
		$("#your-profile > .form-table:eq(0)").remove().appendTo("#tab2"); 	// Contacto		
		$("#your-profile > .form-table:eq(0)").remove().appendTo("#tab1"); 	// Contacto		
		$("#your-profile > .form-table:eq(0)").remove().appendTo("#tab3"); 	// Bio a Acerca de		
		$("#your-profile > .form-table:eq(0)").remove().appendTo("#tab5"); 	// Favoritos
		$("#your-profile > .form-table:eq(0)").remove().appendTo("#tab5"); 	// Recomendaciones
		
		
		$("#your-profile >.form-table").remove().appendTo("#tab5"); //Restos
		
		//Remove section titles (now in tabs)
		$("#wpbody h3").hide(); // Show first tab content
	
		//Start showing first tab
		$("#content > div").hide(); // Initially hide all content
        $("#tabs a:first").addClass("nav-tab-active"); // Activate first tab
        $("#content > div:first").fadeIn(); // Show first tab content
		
		<?php if(!current_user_can('manage_options')):?>		  
		  $("#user_taxonomies").remove()
		<?php endif;?>
		 
		 
        //Prepare click tab actions
        $("#tabs a").on("click",function(e) {
            e.preventDefault();
            if ($(this).is("nav-tab-active"))return;            
            else{             
				resetTabs($(this).attr('name'));
				$(this).addClass("nav-tab-active"); // Activate this
				$($(this).attr('name')).fadeIn(); // Show content for current tab
            }
        });
		
		//Load a Tab if exists in URL
		var myUrl = window.location.href; //get URL
		var myUrlTab = myUrl.substring(myUrl.lastIndexOf("#")); // For localhost/tabs.html#tab2, myUrlTab = #tab2     
		var myUrlTabName = myUrlTab.substring(0,4); // For the above example, myUrlTabName = #tab			
        for (i = 1; i <= $("#tabs a").length; i++) {
          if (myUrlTab == myUrlTabName + i) {
				resetTabs(myUrlTab);
				$("a[name='"+myUrlTab+"']").addClass("nav-tab-active"); // Activate url tab
				$(myUrlTab).fadeIn(); // Show url tab content  
	          }
        }
		
		//Hemos comenzado en oculto por css, ahora mostramos
		$("#wpbody").css("visibility","visible");
	
	});
	
  </script>
  
 <?php
 }
